"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateProductsAndVariations1762912000000 = void 0;
class CreateProductsAndVariations1762912000000 {
    name = 'CreateProductsAndVariations1762912000000';
    async up(queryRunner) {
        console.log('Creating products table with correct foreign key types...');
        await queryRunner.query('DROP TABLE IF EXISTS `product_variations`');
        await queryRunner.query('DROP TABLE IF EXISTS `products`');
        await queryRunner.query(`
            CREATE TABLE \`products\` (
                \`id\` int NOT NULL AUTO_INCREMENT,
                \`name\` varchar(255) NOT NULL,
                \`description\` text NOT NULL,
                \`price\` decimal(10,2) NOT NULL,
                \`image\` varchar(255) NULL,
                \`stock\` int NOT NULL DEFAULT 0,
                \`isFeatured\` tinyint(1) NOT NULL DEFAULT 0,
                \`categoryId\` int NULL,
                \`vendorId\` varchar(36) NULL,
                \`createdAt\` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                \`updatedAt\` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                PRIMARY KEY (\`id\`)
            ) ENGINE=InnoDB
        `);
        await queryRunner.query(`
            CREATE TABLE \`product_variations\` (
                \`id\` int NOT NULL AUTO_INCREMENT,
                \`name\` varchar(255) NOT NULL,
                \`price\` decimal(10,2) NOT NULL,
                \`stock\` int NOT NULL DEFAULT 0,
                \`productId\` int NOT NULL,
                PRIMARY KEY (\`id\`),
                CONSTRAINT \`FK_product_variation_product\` FOREIGN KEY (\`productId\`) REFERENCES \`products\`(\`id\`) ON DELETE CASCADE
            ) ENGINE=InnoDB
        `);
        console.log('Tables created successfully!');
        try {
            await queryRunner.query(`
                ALTER TABLE \`products\`
                ADD CONSTRAINT \`FK_products_category\` 
                FOREIGN KEY (\`categoryId\`) REFERENCES \`categories\`(\`id\`) ON DELETE SET NULL
            `);
            console.log('Added category foreign key (int -> int)');
        }
        catch (error) {
            console.log('Error adding category foreign key:', error.message);
        }
        try {
            await queryRunner.query(`
                ALTER TABLE \`products\`
                ADD CONSTRAINT \`FK_products_vendor\` 
                FOREIGN KEY (\`vendorId\`) REFERENCES \`vendors\`(\`id\`) ON DELETE SET NULL
            `);
            console.log('Added vendor foreign key (varchar -> varchar)');
        }
        catch (error) {
            console.log('Error adding vendor foreign key:', error.message);
        }
        console.log('Migration completed successfully!');
    }
    async down(queryRunner) {
        await queryRunner.query('DROP TABLE IF EXISTS `product_variations`');
        await queryRunner.query('DROP TABLE IF EXISTS `products`');
    }
}
exports.CreateProductsAndVariations1762912000000 = CreateProductsAndVariations1762912000000;
//# sourceMappingURL=1762912300653-CreateProductsAndVariations.js.map